<?php
/**
 *  Template Name: Services page
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page vcvbv nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package abe
 */

get_header();
?>
<div class="inner-banner-container">
<div class="inner-banner">
                <h1>Services</h1>
                <p class="m-auto"><?php echo get_the_content(get_the_ID());?></p>
            </div>
</div>
            <div class="main-container services">
                    <section class="features">
                        <div class="container">
                            <div class="content m-auto">
                                <!-- <h5>Services</h5> -->
                                <h2 class="text-center">
                                    What we do
                                </h2>
                                <p class="subhead m-auto">Team Abe Media offers best in class digital marketing services within a budget. We deliver result-oriented solutions for your business to grow within a short period of time.</p>
                                <div class="col-md-12">
                                <ul class="services-list row">
                                <?php

$query = new WP_Query(array('post_type' => 'what_we_do', 'posts_per_page' => -1,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
    // $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
    ?>
                                        <li class="col-md-6 col-lg-4">
                                           <div class="service-card">
                                                <div class="inner">
                                                <figure class=" <?php echo get_post_meta(get_the_ID(), 'class', true); ?>"></figure>
                                                    <figcaption><?php the_title(); ?></figcaption>
                                                </div>
                                                <div class="card-expander">
                                                <p><?php echo substr(get_the_content(), 0, 100); ?></p>
                                                    <a href="<?php the_permalink();?>"> <span class="arrow"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/arrow.png"></span></a> </div>
                                            </div>
                                        </li>
                                        <?php endwhile; ?> <?php wp_reset_postdata();?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </section>      
<?php get_footer();